import * as React from 'react';
import { Action, DisableableAction } from '../../types';
import { Header, Section } from './components';
export interface Props {
    /** Title content for the card */
    title?: React.ReactNode;
    /** Inner content of the card */
    children?: React.ReactNode;
    /** A less prominent card */
    subdued?: boolean;
    /** Auto wrap content in section */
    sectioned?: boolean;
    /** Card header actions */
    actions?: DisableableAction[];
    /** Primary action in the card footer */
    primaryFooterAction?: Action;
    /** Secondary action in the card footer */
    secondaryFooterAction?: Action;
}
export default class Card extends React.PureComponent<Props, never> {
    static Section: typeof Section;
    static Header: typeof Header;
    static childContextTypes: React.ValidationMap<any>;
    getChildContext(): {
        withinContentContainer: boolean;
    };
    render(): JSX.Element;
}
