import * as React from 'react';
import { WithAppProviderProps } from '../AppProvider';
import { Error } from '../../types';
export interface BaseProps {
    /** Label for the checkbox */
    label: React.ReactNode;
    /** Visually hide the label */
    labelHidden?: boolean;
    /** Checkbox is selected. `indeterminate` shows a horizontal line in the checkbox */
    checked?: boolean | 'indeterminate';
    /** Additional text to aide in use */
    helpText?: React.ReactNode;
    /** Disable input */
    disabled?: boolean;
    /** ID for form input */
    id?: string;
    /** Name for form input */
    name?: string;
    /** Value for form input */
    value?: string;
    /** Display an error message */
    error?: Error | boolean;
    /** Callback when checkbox is toggled */
    onChange?(newChecked: boolean, id: string): void;
    /** Callback when checkbox is focussed */
    onFocus?(): void;
    /** Callback when focus is removed */
    onBlur?(): void;
}
export interface Props extends BaseProps {
}
export declare type CombinedProps = Props & WithAppProviderProps;
declare class Checkbox extends React.PureComponent<CombinedProps, never> {
    private inputNode;
    handleInput: () => void;
    handleKeyUp: (event: React.KeyboardEvent<Element>) => void;
    render(): JSX.Element;
}
declare const _default: React.ComponentClass<Props, React.ComponentState> & typeof Checkbox;
export default _default;
