import * as React from 'react';
import { Error } from '../../types';
export interface Props {
    /** A unique identifier for the choice */
    id: string;
    /**	Label for the choice */
    label: React.ReactNode;
    /** Whether the associated form control is disabled */
    disabled?: Boolean;
    /** Display an error message */
    error?: Error | boolean;
    /** Visually hide the label */
    labelHidden?: boolean;
    /**  Content to display inside the choice */
    children?: React.ReactNode;
    /** Additional text to aide in use */
    helpText?: React.ReactNode;
    /** Callback when clicked */
    onClick?(): void;
}
export default function Choice({ id, label, disabled, error, children, labelHidden, helpText, onClick, }: Props): JSX.Element;
export declare function helpTextID(id: string): string;
