import * as React from 'react';
import { WithAppProviderProps } from '../AppProvider';
import { Error } from '../../types';
export interface ChoiceDescriptor {
    /** Value of the choice */
    value: string;
    /** Label for the choice */
    label: string;
    /** Disable choice */
    disabled?: boolean;
    /** Additional text to aide in use */
    helpText?: React.ReactNode;
    /**  Method to render children with a choice */
    renderChildren?(isSelected: boolean): React.ReactNode | false;
}
export declare type Choice = ChoiceDescriptor;
export interface BaseProps {
    /** Label for list of choices */
    title?: string;
    /** Collection of choices */
    choices: Choice[];
    /** Collection of selected choices */
    selected: string[];
    /** Name for form input */
    name?: string;
    /** Allow merchants to select multiple options at once */
    allowMultiple?: boolean;
    /** Toggles display of the title */
    titleHidden?: boolean;
    /** Display an error message */
    error?: Error;
    /** Callback when the selected choices change */
    onChange?(selected: string[], name: string): void;
}
export interface Props extends BaseProps {
}
export declare type CombinedProps = Props & WithAppProviderProps;
declare function ChoiceList({ title, titleHidden, allowMultiple, choices, selected, onChange, error, name, }: CombinedProps): JSX.Element;
declare const _default: React.ComponentClass<Props, React.ComponentState> & typeof ChoiceList;
export default _default;
