import * as React from 'react';
import { WithAppProviderProps } from '../AppProvider';
export interface Props {
    /** Assign a unique ID to the collapsible. For accessibility, pass this ID as the value of the triggering component’s aria-controls prop. */
    id: string;
    /** Toggle whether the collapsible is expanded or not. */
    open: boolean;
    /** The content to display inside the collapsible. */
    children?: React.ReactNode;
}
export declare type CombinedProps = Props & WithAppProviderProps;
export declare type AnimationState = 'idle' | 'measuring' | 'closingStart' | 'closing' | 'openingStart' | 'opening';
export interface State {
    height?: number | null;
    animationState: AnimationState;
}
export interface Context {
    parentCollapsibleExpanding: boolean;
}
export declare class Collapsible extends React.Component<CombinedProps, State> {
    static contextTypes: {
        parentCollapsibleExpanding: any;
    };
    static childContextTypes: {
        parentCollapsibleExpanding: any;
    };
    context: Partial<Context>;
    state: State;
    private node;
    private heightNode;
    getChildContext(): Context;
    componentWillReceiveProps({ open: willOpen }: Props): void;
    componentDidUpdate({ open: wasOpen }: Props): void;
    componentDidMount(): void;
    componentWillUnmount(): void;
    render(): JSX.Element;
    private bindNode;
    private bindHeightNode;
    private handleTransitionEnd;
}
declare const _default: React.ComponentClass<Props, React.ComponentState> & typeof Collapsible;
export default _default;
