import * as React from 'react';
import { HSBColor, HSBAColor } from '../../utilities/color-types';
export interface State {
    pickerSize: number;
}
export interface Color extends HSBColor {
    /** Level of transparency */
    alpha?: HSBAColor['alpha'];
}
export interface BaseProps {
    /** ID for the element */
    id?: string;
    /** The currently selected color */
    color: Color;
    /** Allow user to select an alpha value */
    allowAlpha?: boolean;
    /** Callback when color is selected */
    onChange(color: HSBAColor): void;
}
export interface Props extends BaseProps {
}
export default class ColorPicker extends React.PureComponent<Props, State> {
    state: State;
    private colorNode;
    componentDidMount(): void;
    render(): JSX.Element;
    private setColorNode;
    private handleHueChange;
    private handleAlphaChange;
    private handleDraggerMove;
}
