import * as React from 'react';
export interface Position {
    x: number;
    y: number;
}
export interface State {
    dragging: boolean;
}
export interface Props {
    draggerX?: number;
    draggerY?: number;
    onChange(position: Position): void;
    onDraggerHeight?(height: number): void;
}
export default class Slidable extends React.PureComponent<Props, State> {
    state: State;
    private node;
    private draggerNode;
    componentDidMount(): void;
    render(): JSX.Element;
    private setDraggerNode;
    private setNode;
    private startDrag;
    private handleDragEnd;
    private handleMove;
    private handleDraggerMove;
}
