import * as React from 'react';
import { WithAppProviderProps } from '../AppProvider';
import { DataTableState, SortDirection } from './types';
export declare type CombinedProps = Props & WithAppProviderProps;
export declare type TableRow = Props['headings'] | Props['rows'] | Props['totals'];
export declare type TableData = string | number | React.ReactNode;
export declare type ColumnContentType = 'text' | 'numeric';
export interface Props {
    /** List of data types, which determines content alignment for each column. Data types are "text," which aligns left, or "numeric," which aligns right. */
    columnContentTypes: ColumnContentType[];
    /** List of column headings. */
    headings: string[];
    /** List of numeric column totals, highlighted in the table’s header below column headings. Use empty strings as placeholders for columns with no total. */
    totals?: TableData[];
    /** Lists of data points which map to table body rows. */
    rows: TableData[][];
    /** Truncate content in first column instead of wrapping.
     * @default false
     */
    truncate?: boolean;
    /** Content centered in the full width cell of the table footer row. */
    footerContent?: TableData;
    /** List of booleans, which maps to whether sorting is enabled or not for each column. Defaults to false for all columns.  */
    sortable?: boolean[];
    /**
     * The direction to sort the table rows on first click or keypress of a sortable column heading. Defaults to ascending.
     * @default 'ascending'
     */
    defaultSortDirection?: SortDirection;
    /**
     * The index of the heading that the table rows are initially sorted by. Defaults to the first column.
     * @default 0
     */
    initialSortColumnIndex?: number;
    /** Callback fired on click or keypress of a sortable column heading. */
    onSort?(headingIndex: number, direction: SortDirection): void;
}
export declare class DataTable extends React.PureComponent<CombinedProps, DataTableState> {
    state: DataTableState;
    private dataTable;
    private scrollContainer;
    private table;
    private totalsRowHeading;
    private handleResize;
    constructor(props: CombinedProps);
    componentDidMount(): void;
    componentDidUpdate(prevProps: Props): void;
    render(): JSX.Element;
    private tallestCellHeights;
    private resetScrollPosition;
    private setHeightsAndScrollPosition;
    private calculateColumnVisibilityData;
    private scrollListener;
    private navigateTable;
    private renderTotals;
    private defaultRenderRow;
    private renderFooter;
    private defaultOnSort;
}
declare const _default: React.ComponentClass<Props, React.ComponentState> & typeof DataTable;
export default _default;
