import * as React from 'react';
import { Range, Months, Year, Weekdays } from '@shopify/javascript-utilities/dates';
import { WithAppProviderProps } from '../AppProvider';
export { Range, Months, Year };
export interface BaseProps {
    /** ID for the element */
    id?: string;
    /** The selected date or range of dates */
    selected?: Date | Range;
    /** The month to show */
    month: Months;
    /** The year to show */
    year: Year;
    /** Allow a range of dates to be selected */
    allowRange?: boolean;
    /** Disable selecting dates before this. */
    disableDatesBefore?: Date;
    /** Disable selecting dates after this. */
    disableDatesAfter?: Date;
    /** The selection can span multiple months */
    multiMonth?: boolean;
    /** First day of week. Sunday by default */
    weekStartsOn?: Weekdays;
    /** Callback when date is selected. */
    onChange?(date: Range): void;
    /** Callback when month is changed. */
    onMonthChange?(month: Months, year: Year): void;
}
export interface Props extends BaseProps {
}
export declare type CombinedProps = Props & WithAppProviderProps;
export interface State {
    hoverDate?: Date;
    focusDate?: Date;
}
export declare class DatePicker extends React.PureComponent<CombinedProps, State> {
    state: State;
    componentDidUpdate(prevProps: Props): void;
    render(): JSX.Element;
    private handleFocus;
    private resetFocus;
    private handleKeyUp;
    private setFocusDateAndHandleMonthChange;
    private handleDateSelection;
    private handleMonthChangeClick;
    private handleHover;
}
declare const _default: React.ComponentClass<Props, React.ComponentState> & typeof DatePicker;
export default _default;
