import * as React from 'react';
import { Range, Weekdays, Months, Year } from '@shopify/javascript-utilities/dates';
import { WithAppProviderProps } from '../../../AppProvider';
export interface Props {
    focusedDate?: Date;
    selected?: Range;
    hoverDate?: Date;
    month: Months;
    year: Year;
    disableDatesBefore?: Date;
    disableDatesAfter?: Date;
    allowRange?: Boolean;
    weekStartsOn: Weekdays;
    onChange?(date: Range): void;
    onHover?(hoverEnd: Date): void;
    onFocus?(date: Date): void;
    monthName?(month: Months): string;
    weekdayName?(weekday: Weekdays): string;
}
export declare type CombinedProps = Props & WithAppProviderProps;
declare function Month({ focusedDate, selected, hoverDate, disableDatesBefore, disableDatesAfter, allowRange, onChange, onHover, onFocus, month, year, weekStartsOn, polaris: { intl }, }: CombinedProps): JSX.Element;
declare const _default: React.ComponentClass<Props, React.ComponentState> & typeof Month;
export default _default;
