import * as React from 'react';
import { HeadingTagName } from '../../types';
export declare type Size = 'small' | 'medium' | 'large' | 'extraLarge';
export interface Props {
    /**
     * Name of element to use for text
     * @default 'p'
     */
    element?: HeadingTagName;
    /**
     * Size of the text
     * @default 'medium'
     */
    size?: Size;
    /** Content to display */
    children?: React.ReactNode;
}
export default function DisplayText({ element: Element, children, size, }: Props): JSX.Element;
