import * as React from 'react';
import { Action } from '../Labelled';
import { WithAppProviderProps } from '../AppProvider';
import { FileUpload } from './components';
import { DropZoneContext } from './types';
export declare type Type = 'file' | 'image';
export interface State {
    id: string;
    size: string;
    type?: string;
    error?: boolean;
    dragging: boolean;
    overlayText?: string;
    errorOverlayText?: string;
    numFiles: number;
}
export interface Props {
    /** Label for the file input */
    label?: string;
    /** Adds an action to the label */
    labelAction?: Action;
    /** Visually hide the label */
    labelHidden?: boolean;
    /** ID for file input */
    id?: string;
    /** Allowed file types */
    accept?: string;
    /**
     * Whether is a file or an image
     * @default 'file'
     */
    type?: Type;
    /** Sets an active state */
    active?: boolean;
    /** Sets an error state */
    error?: boolean;
    /**
     * Displays an outline border
     * @default true
     */
    outline?: boolean;
    /**
     * Displays an overlay on hover
     * @default true
     */
    overlay?: boolean;
    /** Text that appears in the overlay */
    overlayText?: string;
    /** Text that appears in the overlay when set in error state */
    errorOverlayText?: string;
    /**
     * Allows multiple files to be uploaded
     * @default true
     */
    allowMultiple?: boolean;
    /** Sets a disabled state */
    disabled?: boolean;
    /** The child elements to render in the dropzone. */
    children?: string | React.ReactNode;
    /** Allows a file to be dropped anywhere on the page */
    dropOnPage?: boolean;
    /** Sets the default file dialog state */
    openFileDialog?: boolean;
    /** Adds custom validations */
    customValidator?(file: File): boolean;
    /** Callback triggered on click */
    onClick?(event: React.MouseEvent<HTMLElement>): void;
    /** Callback triggered on any file drop */
    onDrop?(files: File[], acceptedFiles: File[], rejectedFiles: File[]): void;
    /** Callback triggered when at least one of the files dropped was accepted */
    onDropAccepted?(acceptedFiles: File[]): void;
    /** Callback triggered when at least one of the files dropped was rejected */
    onDropRejected?(rejectedFiles: File[]): void;
    /** Callback triggered when one or more files are dragging over the drag area */
    onDragOver?(): void;
    /** Callback triggered when one or more files entered the drag area */
    onDragEnter?(): void;
    /** Callback triggered when one or more files left the drag area */
    onDragLeave?(): void;
    /** Callback triggered when the file dialog is canceled */
    onFileDialogClose?(): void;
}
export declare type CombinedProps = Props & WithAppProviderProps;
export declare class DropZone extends React.Component<CombinedProps, State> {
    static FileUpload: typeof FileUpload;
    static defaultProps: Partial<CombinedProps>;
    static getDerivedStateFromProps(nextProps: CombinedProps, prevState: State): any;
    private node;
    private dragTargets;
    private fileInputNode;
    private adjustSize;
    constructor(props: CombinedProps);
    readonly getContext: DropZoneContext;
    readonly dropNode: Document | HTMLDivElement | null;
    render(): JSX.Element;
    componentDidMount(): void;
    componentWillUnmount(): void;
    componentDidUpdate(): void;
    private triggerFileDialog;
    private open;
    private getValidatedFiles;
    private handleClick;
    private handleDrop;
    private handleDragEnter;
    private handleDragOver;
    private handleDragLeave;
}
declare const _default: React.ComponentClass<Props, React.ComponentState> & typeof DropZone;
export default _default;
