import * as React from 'react';
import { Action } from '../../types';
export interface Props {
    /** The empty state heading */
    heading?: string;
    /** The image to use for small screens */
    image: string;
    /** The image to use for large screens */
    largeImage?: string;
    /** The image to use for large screens */
    imageContained?: boolean;
    /** Elements to display inside empty state */
    children?: React.ReactNode;
    /** Primary action for empty state */
    action: Action;
    /** Secondary action for empty state */
    secondaryAction?: Action;
    /** Secondary elements to display below empty state actions */
    footerContent?: React.ReactNode;
}
export default class EmptyState extends React.PureComponent<Props, never> {
    render(): JSX.Element;
}
