import * as React from 'react';
export interface BaseEventProps {
    event: string;
    capture?: boolean;
    handler(event: Event): void;
}
export interface Props extends BaseEventProps {
    passive?: boolean;
}
export default class EventListener extends React.PureComponent<Props, never> {
    componentDidMount(): void;
    componentDidUpdate({ passive, ...detachProps }: Props): void;
    componentWillUnmount(): void;
    render(): null;
    private attachListener;
    private detachListener;
}
