import * as React from 'react';
import { Props as IconProps } from '../Icon';
export declare type Description = string | React.ReactElement<any> | (string | React.ReactElement<any>)[];
export interface Item {
    /** Set the color of the icon and title for the given item. */
    status?: 'critical' | 'warning';
    /** Icon displayed by the list item */
    icon?: IconProps['source'];
    /** Text displayed beside the icon */
    title?: string;
    /** Text displayed for the item */
    description?: Description;
    /** Should the description be truncated at end of line */
    truncate?: boolean;
}
export interface Props {
    /** Collection of items for list */
    items: Item[];
}
export default function ExceptionList({ items: itemsList }: Props): JSX.Element;
