import * as React from 'react';
import { WithAppProviderProps } from '../AppProvider';
import { FrameContext, ToastProps } from './types';
export interface Props {
    /** Accepts a top bar component that will be rendered at the top-most portion of an application frame */
    topBar?: React.ReactNode;
    /** Accepts a navigation component that will be rendered in the left sidebar of an application frame */
    navigation?: React.ReactNode;
    /** Accepts a global ribbon component that will be rendered fixed to the bottom of an application frame */
    globalRibbon?: React.ReactNode;
    /** A boolean property indicating whether the mobile navigation is currently visible
     * @default false
     */
    showMobileNavigation?: boolean;
    /** A callback function to handle clicking the mobile navigation dismiss button */
    onNavigationDismiss?(): void;
}
export interface State {
    mobileView?: boolean;
    skipFocused?: boolean;
    globalRibbonHeight: number;
    loadingStack: number;
    toastMessages: (ToastProps & {
        id: string;
    })[];
    showContextualSaveBar: boolean;
}
export declare const GLOBAL_RIBBON_CUSTOM_PROPERTY = "--global-ribbon-height";
export declare const APP_FRAME_MAIN = "AppFrameMain";
export declare type CombinedProps = Props & WithAppProviderProps;
export declare class Frame extends React.PureComponent<CombinedProps, State> {
    static childContextTypes: {
        frame: any;
    };
    state: State;
    private contextualSaveBar;
    private globalRibbonContainer;
    getChildContext(): FrameContext;
    componentDidMount(): void;
    componentDidUpdate(prevProps: Props): void;
    render(): JSX.Element;
    private setGlobalRibbonHeight;
    private setGlobalRibbonRootProperty;
    private showToast;
    private hideToast;
    private setContextualSaveBar;
    private removeContextualSaveBar;
    private startLoading;
    private stopLoading;
    private handleResize;
    private handleClick;
    private handleFocus;
    private handleBlur;
    private handleNavigationDismiss;
    private setGlobalRibbonContainer;
    private handleNavKeydown;
}
declare const _default: React.ComponentClass<Props, React.ComponentState> & typeof Frame;
export default _default;
