import * as React from 'react';
import { SVGSource } from '@shopify/images';
import { WithAppProviderProps } from '../AppProvider';
export declare type Color = 'white' | 'black' | 'skyLighter' | 'skyLight' | 'sky' | 'skyDark' | 'inkLightest' | 'inkLighter' | 'inkLight' | 'ink' | 'blueLighter' | 'blueLight' | 'blue' | 'blueDark' | 'blueDarker' | 'indigoLighter' | 'indigoLight' | 'indigo' | 'indigoDark' | 'indigoDarker' | 'tealLighter' | 'tealLight' | 'teal' | 'tealDark' | 'tealDarker' | 'greenLighter' | 'green' | 'greenDark' | 'yellowLighter' | 'yellow' | 'yellowDark' | 'orange' | 'redLighter' | 'red' | 'redDark' | 'purple';
export declare const BUNDLED_ICONS: {
    add: React.StatelessComponent<React.SVGProps<SVGSVGElement>>;
    alert: React.StatelessComponent<React.SVGProps<SVGSVGElement>>;
    arrowDown: React.StatelessComponent<React.SVGProps<SVGSVGElement>>;
    arrowLeft: React.StatelessComponent<React.SVGProps<SVGSVGElement>>;
    arrowRight: React.StatelessComponent<React.SVGProps<SVGSVGElement>>;
    arrowUp: React.StatelessComponent<React.SVGProps<SVGSVGElement>>;
    arrowUpDown: React.StatelessComponent<React.SVGProps<SVGSVGElement>>;
    calendar: React.StatelessComponent<React.SVGProps<SVGSVGElement>>;
    cancel: React.StatelessComponent<React.SVGProps<SVGSVGElement>>;
    cancelSmall: React.StatelessComponent<React.SVGProps<SVGSVGElement>>;
    caretDown: React.StatelessComponent<React.SVGProps<SVGSVGElement>>;
    caretUp: React.StatelessComponent<React.SVGProps<SVGSVGElement>>;
    checkmark: React.StatelessComponent<React.SVGProps<SVGSVGElement>>;
    chevronDown: React.StatelessComponent<React.SVGProps<SVGSVGElement>>;
    chevronLeft: React.StatelessComponent<React.SVGProps<SVGSVGElement>>;
    chevronRight: React.StatelessComponent<React.SVGProps<SVGSVGElement>>;
    chevronUp: React.StatelessComponent<React.SVGProps<SVGSVGElement>>;
    circleCancel: React.StatelessComponent<React.SVGProps<SVGSVGElement>>;
    circleChevronDown: React.StatelessComponent<React.SVGProps<SVGSVGElement>>;
    circleChevronLeft: React.StatelessComponent<React.SVGProps<SVGSVGElement>>;
    circleChevronRight: React.StatelessComponent<React.SVGProps<SVGSVGElement>>;
    circleChevronUp: React.StatelessComponent<React.SVGProps<SVGSVGElement>>;
    circleInformation: React.StatelessComponent<React.SVGProps<SVGSVGElement>>;
    circlePlus: React.StatelessComponent<React.SVGProps<SVGSVGElement>>;
    circlePlusOutline: React.StatelessComponent<React.SVGProps<SVGSVGElement>>;
    conversation: React.StatelessComponent<React.SVGProps<SVGSVGElement>>;
    delete: React.StatelessComponent<React.SVGProps<SVGSVGElement>>;
    disable: React.StatelessComponent<React.SVGProps<SVGSVGElement>>;
    dispute: React.StatelessComponent<React.SVGProps<SVGSVGElement>>;
    duplicate: React.StatelessComponent<React.SVGProps<SVGSVGElement>>;
    embed: React.StatelessComponent<React.SVGProps<SVGSVGElement>>;
    export: React.StatelessComponent<React.SVGProps<SVGSVGElement>>;
    external: React.StatelessComponent<React.SVGProps<SVGSVGElement>>;
    help: React.StatelessComponent<React.SVGProps<SVGSVGElement>>;
    home: React.StatelessComponent<React.SVGProps<SVGSVGElement>>;
    horizontalDots: React.StatelessComponent<React.SVGProps<SVGSVGElement>>;
    import: React.StatelessComponent<React.SVGProps<SVGSVGElement>>;
    logOut: React.StatelessComponent<React.SVGProps<SVGSVGElement>>;
    menu: React.StatelessComponent<React.SVGProps<SVGSVGElement>>;
    notes: React.StatelessComponent<React.SVGProps<SVGSVGElement>>;
    notification: React.StatelessComponent<React.SVGProps<SVGSVGElement>>;
    onlineStore: React.StatelessComponent<React.SVGProps<SVGSVGElement>>;
    orders: React.StatelessComponent<React.SVGProps<SVGSVGElement>>;
    print: React.StatelessComponent<React.SVGProps<SVGSVGElement>>;
    products: React.StatelessComponent<React.SVGProps<SVGSVGElement>>;
    profile: React.StatelessComponent<React.SVGProps<SVGSVGElement>>;
    refresh: React.StatelessComponent<React.SVGProps<SVGSVGElement>>;
    risk: React.StatelessComponent<React.SVGProps<SVGSVGElement>>;
    save: React.StatelessComponent<React.SVGProps<SVGSVGElement>>;
    search: React.StatelessComponent<React.SVGProps<SVGSVGElement>>;
    subtract: React.StatelessComponent<React.SVGProps<SVGSVGElement>>;
    view: React.StatelessComponent<React.SVGProps<SVGSVGElement>>;
};
export declare type BundledIcon = keyof typeof BUNDLED_ICONS;
export declare type UntrustedSVG = string;
export declare type IconSource = React.ReactNode | React.SFC<React.SVGProps<SVGSVGElement>> | SVGSource | 'placeholder' | BundledIcon | UntrustedSVG;
export interface Props {
    /** The SVG contents to display in the icon. Icons should be in a 20 X 20 pixel viewbox */
    source: IconSource;
    /** Sets the color for the SVG fill */
    color?: Color;
    /** Show a backdrop behind the icon */
    backdrop?: boolean;
    /** Descriptive text to be read to screenreaders */
    accessibilityLabel?: string;
    /** Render the icon in an img tag instead of an svg. Prevents XSS */
    /** @deprecated the untrusted prop is deprecated and will be removed. All raw strings passed into the Icon component will be assumed to be untrusted */
    untrusted?: boolean;
}
export declare type CombinedProps = Props & WithAppProviderProps;
declare function Icon({ source, color, backdrop, accessibilityLabel, untrusted, polaris: { intl }, }: CombinedProps): JSX.Element;
declare const _default: React.ComponentClass<Props, React.ComponentState> & typeof Icon;
export default _default;
