import * as React from 'react';
export interface SourceSet {
    source: string;
    descriptor?: string;
}
export declare type CrossOrigin = 'anonymous' | 'use-credentials' | '' | undefined;
export interface Props extends React.HTMLProps<HTMLImageElement> {
    alt: string;
    source: string;
    sourceSet?: SourceSet[];
    onLoad?(): void;
    onError?(): void;
}
export default function Image({ sourceSet, source, crossOrigin, ...rest }: Props): JSX.Element;
