import * as React from 'react';
import { WithAppProviderProps } from '../AppProvider';
export interface BaseProps {
    /** ID for the link */
    id?: string;
    /** The url to link to */
    url?: string;
    /** The content to display inside link */
    children?: React.ReactNode;
    /** Use for a links that open a different site */
    external?: boolean;
    /** Makes the link color the same as the current text color and adds an underline */
    monochrome?: boolean;
    /** Callback when a link is clicked */
    onClick?(): void;
}
export interface Props extends BaseProps {
}
export declare type CombinedProps = Props & WithAppProviderProps;
declare function Link({ url, children, onClick, external, id, monochrome, polaris, }: CombinedProps): JSX.Element;
declare const _default: React.ComponentClass<Props, React.ComponentState> & typeof Link;
export default _default;
