import * as React from 'react';
import { WithAppProviderProps } from '../AppProvider';
import { Dialog, FooterProps, Section } from './components';
export declare type Size = 'Small' | 'Medium' | 'Large' | 'Full';
export interface Props extends FooterProps {
    /** Whether the modal is open or not */
    open: boolean;
    /** The url that will be loaded as the content of the modal */
    src?: string;
    /** The name of the modal content iframe */
    iFrameName?: string;
    /** The content for the title of the modal (embedded app use accepts string only) */
    title?: string | React.ReactNode;
    /** The content to display inside modal (stand-alone app use only) */
    children?: React.ReactNode;
    /** Inner content of the footer (stand-alone app use only) */
    footer?: React.ReactNode;
    /** Disable animations and open modal instantly (stand-alone app use only) */
    instant?: boolean;
    /** Automatically adds sections to modal (stand-alone app use only) */
    sectioned?: boolean;
    /** Increases the modal width (stand-alone app use only) */
    large?: boolean;
    /** Limits modal height on large sceens with scrolling (stand-alone app use only) */
    limitHeight?: boolean;
    /** Replaces modal content with a spinner while a background action is being performed (stand-alone app use only) */
    loading?: boolean;
    /**
     * Controls the size of the modal
     * @default 'Small'
     * @embeddedAppOnly
     */
    size?: Size;
    /**
     * Message to display inside modal
     * @embeddedAppOnly
     */
    message?: string;
    /** Callback when the modal is closed */
    onClose(): void;
    /** Callback when iframe has loaded (stand-alone app use only) */
    onIFrameLoad?(evt: React.SyntheticEvent<HTMLIFrameElement>): void;
    /** Callback when modal transition animation has ended (stand-alone app use only) */
    onTransitionEnd?(): void;
    /** Callback when the bottom of the modal content is reached */
    onScrolledToBottom?(): void;
}
export declare type CombinedProps = Props & WithAppProviderProps;
export interface State {
    iframeHeight: number;
}
export declare class Modal extends React.Component<CombinedProps, State> {
    static childContextTypes: React.ValidationMap<any>;
    static Dialog: typeof Dialog;
    static Section: typeof Section;
    focusReturnPointNode: HTMLElement;
    state: State;
    private headerId;
    private appBridgeModal;
    getChildContext(): {
        withinContentContainer: boolean;
    };
    componentDidMount(): void;
    componentDidUpdate(prevProps: CombinedProps): void;
    componentWillUnmount(): void;
    render(): JSX.Element | null;
    private handleEntered;
    private handleExited;
    private handleIFrameLoad;
    private transformProps;
}
declare const _default: React.ComponentClass<Props, React.ComponentState> & typeof Modal;
export default _default;
