import * as React from 'react';
import { UserMenu, Section } from './components';
import { SectionType } from './types';
export interface Props {
    location: string;
    sections?: SectionType[];
    children?: React.ReactNode;
    /** @deprecated Pass a user menu into <TopBar /> instead. */
    userMenu?: React.ReactNode;
    contextControl?: React.ReactNode;
    onDismiss?(): void;
}
export default class Navigation extends React.Component<Props, never> {
    static Item: React.ComponentClass<import("./components/Item/Item").Props, React.ComponentState> & typeof import("./components/Item/Item").BaseItem;
    static UserMenu: typeof UserMenu;
    static Section: typeof Section;
    static childContextTypes: {
        location: any;
        onNavigationDismiss: any;
    };
    constructor(props: Props);
    getChildContext(): {
        location: string;
        onNavigationDismiss: (() => void) | undefined;
    };
    render(): JSX.Element;
}
