import * as React from 'react';
import { Context } from '../../types';
import { WithAppProviderProps } from '../../../AppProvider';
import { Props as IconProps } from '../../../Icon';
interface ItemURLDetails {
    url?: string;
    matches?: boolean;
    exactMatch?: boolean;
    matchPaths?: string[];
    excludePaths?: string[];
}
export interface SubNavigationItem extends ItemURLDetails {
    url: string;
    label: string;
    disabled?: boolean;
    new?: boolean;
    onClick?(event: React.MouseEvent<HTMLElement>): void;
}
interface SecondaryAction {
    url: string;
    accessibilityLabel: string;
    icon: IconProps['source'];
}
export interface Props extends ItemURLDetails {
    icon?: IconProps['source'];
    /** @deprecated The iconBody prop is deprecated and will be removed. Pass a string into the icon prop instead */
    iconBody?: string;
    badge?: React.ReactNode;
    label: string;
    disabled?: boolean;
    accessibilityLabel?: string;
    selected?: boolean;
    exactMatch?: boolean;
    new?: boolean;
    subNavigationItems?: SubNavigationItem[];
    secondaryAction?: SecondaryAction;
    onClick?(): void;
}
export declare type CombinedProps = Props & WithAppProviderProps;
interface State {
    expanded: boolean;
}
export declare class BaseItem extends React.Component<CombinedProps, State> {
    static contextTypes: {
        location: any;
        onNavigationDismiss: any;
    };
    context: Context;
    state: State;
    componentDidMount(): void;
    componentWillUnmount(): void;
    render(): React.ReactElement<Props>;
    private handleResize;
    private getClickHandler;
}
export declare function isNavigationItemActive(navigationItem: Props, currentPath: string): boolean | undefined;
export declare const Item: React.ComponentClass<Props, React.ComponentState> & typeof BaseItem;
export default Item;
