import * as React from 'react';
import { WithAppProviderProps } from '../AppProvider';
import { Props as IconProps } from '../Icon';
import { Props as AvatarProps } from '../Avatar';
import { Props as ThumbnailProps } from '../Thumbnail';
export interface OptionDescriptor {
    /** Value of the option */
    value: string;
    /** Display label for the option */
    label: React.ReactNode;
    /** Whether the option is disabled or not */
    disabled?: boolean;
    /** Whether the option is active or not */
    active?: boolean;
    /** Unique identifier for the option */
    id?: string;
    /** Media to display to the left of the option content */
    media?: React.ReactElement<IconProps | ThumbnailProps | AvatarProps>;
}
export interface SectionDescriptor {
    /** Collection of options within the section */
    options: OptionDescriptor[];
    /** Section title */
    title?: string;
}
export interface Props {
    /** A unique identifier for the option list */
    id?: string;
    /** List title */
    title?: string;
    /** Collection of options to be listed */
    options?: OptionDescriptor[];
    /** Defines a specific role attribute for the list itself */
    role?: string;
    /** Defines a specific role attribute for each option in the list */
    optionRole?: string;
    /** Sections containing a header and related options */
    sections?: SectionDescriptor[];
    /** The selected options */
    selected: string[];
    /** Allow more than one option to be selected */
    allowMultiple?: boolean;
    /** Callback when selection is changed */
    onChange(selected: string[]): void;
}
export interface State {
    normalizedOptions: SectionDescriptor[];
}
export declare type CombinedProps = Props & WithAppProviderProps;
export declare class OptionList extends React.Component<CombinedProps, State> {
    state: State;
    private id;
    componentWillReceiveProps({ options: nextOptions, sections: nextSections, id: nextID, title: nextTitle, }: Props): void;
    render(): JSX.Element;
    private handleClick;
}
declare const _default: React.ComponentClass<Props, React.ComponentState> & typeof OptionList;
export default _default;
