import * as React from 'react';
import { WithAppProviderProps } from '../AppProvider';
import { HeaderProps } from './components';
export interface Props extends HeaderProps {
    /** The contents of the page */
    children?: React.ReactNode;
    /** Remove the normal max-width on the page */
    fullWidth?: boolean;
    /** Decreases the maximum layout width. Intended for single-column layouts */
    singleColumn?: boolean;
    /**
     * Force render in page and do not delegate to the app bridge TitleBar action
     * @default false
     * @embeddedAppOnly
     * @see {@link https://polaris.shopify.com/components/structure/page#section-use-in-an-embedded-application|Shopify Page Component docs}
     * */
    forceRender?: boolean;
}
export declare type ComposedProps = Props & WithAppProviderProps;
export declare class Page extends React.PureComponent<ComposedProps, never> {
    private titlebar;
    componentDidMount(): void;
    componentDidUpdate(prevProps: ComposedProps): void;
    componentWillUnmount(): void;
    render(): JSX.Element;
    private readonly delegateToAppbridge;
    private hasHeaderContent;
    private transformProps;
    private transformBreadcrumbs;
}
declare const _default: React.ComponentClass<Props, React.ComponentState> & typeof Page;
export default _default;
