import * as React from 'react';
import { DisableableAction, LoadableAction, DestructableAction, IconableAction, AppBridgeAction, AppBridgeActionTarget } from '../../../../types';
import { Props as BreadcrumbsProps } from '../../../Breadcrumbs';
import { PaginationDescriptor } from '../../../Pagination';
import { WithAppProviderProps } from '../../../AppProvider';
import { ActionGroupDescriptor } from './components';
export interface SecondaryAction extends IconableAction, DisableableAction, AppBridgeActionTarget {
}
export interface PrimaryActionProps extends DisableableAction, LoadableAction, AppBridgeAction, DestructableAction {
    /** Provides extra visual weight and identifies the primary action in a set of buttons */
    primary?: boolean;
}
export interface Props {
    /** Page title, in large type */
    title: string;
    /** Important and non-interactive status information shown immediately after the title. (stand-alone app use only) */
    titleMetadata?: React.ReactNode;
    /** Visually hide the title (stand-alone app use only) */
    titleHidden?: boolean;
    /**
     * Application icon for identifying embedded applications
     * @embeddedAppOnly
     */
    icon?: string;
    /** Collection of breadcrumbs */
    breadcrumbs?: BreadcrumbsProps['breadcrumbs'];
    /** Adds a border to the bottom of the page header (stand-alone app use only) */
    separator?: boolean;
    /** Collection of secondary page-level actions */
    secondaryActions?: SecondaryAction[];
    /** Collection of page-level groups of secondary actions */
    actionGroups?: ActionGroupDescriptor[];
    /** Primary page-level action */
    primaryAction?: PrimaryActionProps;
    /** Page-level pagination (stand-alone app use only) */
    pagination?: PaginationDescriptor;
}
export interface State {
    openActionGroup?: string;
    rollupOpen: boolean;
}
export declare type CombinedProps = Props & WithAppProviderProps;
declare class Header extends React.PureComponent<CombinedProps, State> {
    state: State;
    render(): JSX.Element;
    private readonly hasRollup;
    private renderRollupAction;
    private renderSecondaryActions;
    private handleRollupToggle;
    private handleActionGroupClose;
    private handleActionGroupOpen;
}
declare const _default: React.ComponentClass<Props, React.ComponentState> & typeof Header;
export default _default;
