import * as React from 'react';
import { WithAppProviderProps } from '../AppProvider';
import { Key } from '../../types';
export interface PaginationDescriptor {
    /** Keyboard shortcuts for the next button */
    nextKeys?: Key[];
    /** Keyboard shortcuts for the previous button */
    previousKeys?: Key[];
    /** Tooltip for the next button */
    nextTooltip?: string;
    /** Tooltip for the previous button */
    previousTooltip?: string;
    /** The URL of the next page */
    nextURL?: string;
    /** The URL of the previous page */
    previousURL?: string;
    /** Whether there is a next page to show */
    hasNext?: boolean;
    /** Whether there is a previous page to show */
    hasPrevious?: boolean;
    /** Accessible label for the pagination */
    accessibilityLabel?: string;
    /** Callback when next button is clicked */
    onNext?(): void;
    /** Callback when previous button is clicked */
    onPrevious?(): void;
}
export interface Props extends PaginationDescriptor {
    /** A more subdued control for use in headers */
    plain?: boolean;
}
export declare type CombinedProps = Props & WithAppProviderProps;
declare function Pagination({ hasNext, hasPrevious, nextURL, previousURL, onNext, onPrevious, nextTooltip, previousTooltip, nextKeys, previousKeys, plain, accessibilityLabel, polaris: { intl }, }: CombinedProps): JSX.Element;
declare const _default: React.ComponentClass<Props, React.ComponentState> & typeof Pagination;
export default _default;
