import * as React from 'react';
import { PreferredPosition, PreferredAlignment } from '../PositionedOverlay';
import { CloseSource, Pane, Section } from './components';
export { CloseSource };
export interface Props {
    /** The content to display inside the popover */
    children?: React.ReactNode;
    /** The preferred direction to open the popover */
    preferredPosition?: PreferredPosition;
    /** The preferred alignment of the popover relative to its activator */
    preferredAlignment?: PreferredAlignment;
    /** Show or hide the Popover */
    active: boolean;
    /** The element to activate the Popover */
    activator: React.ReactElement<any>;
    /**
     * The element type to wrap the activator with
     * @default 'div'
     */
    activatorWrapper?: string;
    /** Prevent automatic focus of the first field on activation */
    preventAutofocus?: boolean;
    /** Automatically add wrap content in a section */
    sectioned?: boolean;
    /** Allow popover to stretch to the full width of its activator */
    fullWidth?: boolean;
    /** Allow popover to stretch to fit content vertically */
    fullHeight?: boolean;
    /** Remains in a fixed position */
    fixed?: boolean;
    /** Callback when popover is closed */
    onClose(source: CloseSource): void;
}
export interface State {
    activatorNode: HTMLElement | null;
}
export default class Popover extends React.PureComponent<Props, State> {
    static Pane: typeof Pane;
    static Section: typeof Section;
    state: State;
    private activatorContainer;
    private id;
    componentDidMount(): void;
    componentDidUpdate(): void;
    render(): JSX.Element;
    private setAccessibilityAttributes;
    private handleClose;
    private setActivator;
}
