import * as React from 'react';
import { PreferredPosition, PreferredAlignment } from '../../../PositionedOverlay';
export declare enum CloseSource {
    Click = 0,
    EscapeKeypress = 1,
    FocusOut = 2,
    ScrollOut = 3
}
export interface Props {
    children?: React.ReactNode;
    fullWidth?: boolean;
    fullHeight?: boolean;
    preferredPosition?: PreferredPosition;
    preferredAlignment?: PreferredAlignment;
    active: boolean;
    id: string;
    activator: HTMLElement;
    preventAutofocus?: boolean;
    sectioned?: boolean;
    fixed?: boolean;
    onClose(source: CloseSource): void;
}
export default class PopoverOverlay extends React.PureComponent<Props, never> {
    private contentNode;
    private transitionStatus;
    componentDidMount(): void;
    componentDidUpdate(oldProps: Props): void;
    render(): JSX.Element;
    private focusContent;
    private renderOverlay;
    private renderPopover;
    private handleClick;
    private handleScrollOut;
    private handleEscape;
    private handleFocusFirstItem;
    private handleFocusLastItem;
}
