import * as React from 'react';
export interface Props {
    children?: React.ReactNode;
    idPrefix?: string;
    onPortalCreated?(): void;
}
export interface State {
    isMounted: boolean;
}
export default class Portal extends React.PureComponent<Props, State> {
    static defaultProps: {
        idPrefix: string;
    };
    state: State;
    private portalNode;
    private portalId;
    componentDidMount(): void;
    componentDidUpdate(_: Props, prevState: State): void;
    componentWillUnmount(): void;
    render(): React.ReactPortal | null;
}
