import * as React from 'react';
export interface BaseProps {
    /** Label for the radio button */
    label: React.ReactNode;
    /** Visually hide the label */
    labelHidden?: boolean;
    /** Radio button is selected */
    checked?: boolean;
    /** Additional text to aid in use */
    helpText?: React.ReactNode;
    /** Disable input */
    disabled?: boolean;
    /** ID for form input */
    id?: string;
    /** Name for form input */
    name?: string;
    /** Value for form input */
    value?: string;
    /** Callback when the radio button is toggled */
    onChange?(newValue: boolean, id: string): void;
    /** Callback when radio button is focussed */
    onFocus?(): void;
    /** Callback when focus is removed */
    onBlur?(): void;
}
export interface Props extends BaseProps {
}
export default function RadioButton({ label, labelHidden, helpText, checked, disabled, onChange, onFocus, onBlur, id, name, value, }: Props): JSX.Element;
