import * as React from 'react';
import { Error } from '../../types';
import { WithAppProviderProps } from '../AppProvider';
import { Action } from '../Labelled';
export interface State {
    id: string;
}
export interface BaseProps {
    /** Label for the range input */
    label: string;
    /** Adds an action to the label */
    labelAction?: Action;
    /** Visually hide the label */
    labelHidden?: boolean;
    /** ID for range input */
    id?: string;
    /** Initial value for range input */
    value: number;
    /** Minimum possible value for range input */
    min?: number;
    /** Maximum possible value for range input */
    max?: number;
    /** Increment value for range input changes */
    step?: number;
    /** Provide a tooltip while sliding, indicating the current value */
    output?: boolean;
    /** Additional text to aid in use */
    helpText?: React.ReactNode;
    /** Display an error message */
    error?: Error;
    /** Disable input */
    disabled?: boolean;
    /** Element to display before the input */
    prefix?: React.ReactNode;
    /** Element to display after the input */
    suffix?: React.ReactNode;
    /** Callback when the range input is changed */
    onChange(value: number, id: string): void;
    /** Callback when range input is focused */
    onFocus?(): void;
    /** Callback when focus is removed */
    onBlur?(): void;
}
export interface Props extends BaseProps {
}
export declare type CombinedProps = Props & WithAppProviderProps;
export declare class RangeSlider extends React.PureComponent<CombinedProps, State> {
    static getDerivedStateFromProps(nextProps: CombinedProps, prevState: State): {
        id: string;
    } | null;
    constructor(props: CombinedProps);
    render(): JSX.Element;
    private handleChange;
}
export declare function invertNumber(number: number): number;
declare const _default: React.ComponentClass<Props, React.ComponentState> & typeof RangeSlider;
export default _default;
