import * as React from 'react';
import { WithAppProviderProps } from '../AppProvider';
import { SelectOption } from '../Select';
import { BulkActionsProps, FilterControl, Item } from './components';
import { ResourceListContext, SelectedItems } from './types';
export declare type Items = any[];
export interface State {
    selectMode: boolean;
    loadingPosition: number;
}
export interface Props {
    /** Item data; each item is passed to renderItem */
    items: Items;
    filterControl?: React.ReactNode;
    /** Name of the resource, such as customers or products */
    resourceName?: {
        singular: string;
        plural: string;
    };
    /** Up to 2 bulk actions that will be given more prominence */
    promotedBulkActions?: BulkActionsProps['promotedActions'];
    /** Actions available on the currently selected items */
    bulkActions?: BulkActionsProps['actions'];
    /** Collection of IDs for the currently selected items */
    selectedItems?: SelectedItems;
    /** If there are more items than currently in the list */
    hasMoreItems?: boolean;
    /** Overlays item list with a spinner while a background action is being performed */
    loading?: boolean;
    /** Boolean to show or hide the header */
    showHeader?: boolean;
    /** Current value of the sort control */
    sortValue?: string;
    /** Collection of sort options to choose from */
    sortOptions?: SelectOption[];
    /** ReactNode to display instead of the sort control */
    alternateTool?: React.ReactNode;
    /** Callback when sort option is changed */
    onSortChange?(selected: string, id: string): void;
    /** Callback when selection is changed */
    onSelectionChange?(selectedItems: SelectedItems): void;
    /** Function to render each list item	 */
    renderItem(item: any, id: string): React.ReactNode;
    /** Function to customize the unique ID for each item */
    idForItem?(item: any, index: number): string;
}
export declare type CombinedProps = Props & WithAppProviderProps;
export declare class ResourceList extends React.Component<CombinedProps, State> {
    static Item: typeof Item;
    static FilterControl: typeof FilterControl;
    private defaultResourceName;
    private listRef;
    private handleResize;
    constructor(props: CombinedProps);
    private readonly selectable;
    private readonly bulkSelectState;
    private readonly headerTitle;
    private readonly bulkActionsLabel;
    private readonly bulkActionsAccessibilityLabel;
    private readonly paginatedSelectAllText;
    private readonly paginatedSelectAllAction;
    private readonly emptySearchResultText;
    readonly getContext: ResourceListContext;
    componentDidMount(): void;
    componentDidUpdate({ loading: prevLoading, items: prevItems, selectedItems: prevSelectedItems, }: Props): void;
    render(): JSX.Element;
    private itemsExist;
    private setLoadingPosition;
    private handleSelectAllItemsInStore;
    private renderItem;
    private handleSelectionChange;
    private handleSelectMode;
    private handleToggleAll;
}
declare const _default: React.ComponentClass<Props, React.ComponentState> & typeof ResourceList;
export default _default;
