import * as React from 'react';
import { DisableableAction, Action, ActionListSection } from '../../../../types';
import { WithAppProviderProps } from '../../../AppProvider';
export declare type BulkAction = DisableableAction;
export declare type BulkActionListSection = ActionListSection;
export declare type TransitionStatus = 'entering' | 'entered' | 'exiting' | 'exited';
export interface Props {
    /** Visually hidden text for screen readers */
    accessibilityLabel?: string;
    /** Label for the bulk actions */
    label?: string;
    /** State of the bulk actions checkbox */
    selected?: boolean | 'indeterminate';
    /** List is in a selectable state */
    selectMode?: boolean;
    /** Actions that will be given more prominence */
    promotedActions?: BulkAction[];
    /** List of actions */
    actions?: (BulkAction | BulkActionListSection)[];
    /** Text to select all across pages */
    paginatedSelectAllText?: string;
    /** Action for selecting all across pages */
    paginatedSelectAllAction?: Action;
    /** Disables bulk actions */
    disabled?: boolean;
    /** Callback when the select all checkbox is clicked */
    onToggleAll?(): void;
    /** Callback when selectable state of list is changed */
    onSelectModeToggle?(selectMode: boolean): void;
}
export interface State {
    smallScreenPopoverVisible: boolean;
    largeScreenPopoverVisible: boolean;
    containerWidth: number;
    measuring: boolean;
}
export declare type CombinedProps = Props & WithAppProviderProps;
export declare class BulkActions extends React.PureComponent<CombinedProps, State> {
    state: {
        smallScreenPopoverVisible: boolean;
        largeScreenPopoverVisible: boolean;
        containerWidth: number;
        measuring: boolean;
    };
    private containerNode;
    private largeScreenButtonsNode;
    private moreActionsNode;
    private promotedActionsWidths;
    private bulkActionsWidth;
    private addedMoreActionsWidthForMeasuring;
    private handleResize;
    private readonly numberOfPromotedActionsToRender;
    private readonly hasActions;
    private readonly actionSections;
    componentDidMount(): void;
    render(): JSX.Element;
    private setLargeScreenButtonsNode;
    private setContainerNode;
    private setMoreActionsNode;
    private setSelectMode;
    private toggleSmallScreenPopover;
    private toggleLargeScreenPopover;
    private handleMeasurement;
}
declare const _default: React.ComponentClass<Props, React.ComponentState> & typeof BulkActions;
export default _default;
