import * as React from 'react';
import { ComplexAction, WithContextTypes } from '../../../../types';
import { WithAppProviderProps } from '../../../AppProvider';
import { ResourceListContext } from '../../types';
import { AppliedFilter, Filter } from './types';
export interface Props {
    searchValue?: string;
    appliedFilters?: AppliedFilter[];
    additionalAction?: ComplexAction;
    focused?: boolean;
    filters?: Filter[];
    placeholder?: string;
    onSearchBlur?(): void;
    onSearchChange(searchValue: string, id: string): void;
    onFiltersChange?(appliedFilters: AppliedFilter[]): void;
}
export declare type CombinedProps = Props & WithAppProviderProps & WithContextTypes<ResourceListContext>;
export declare class FilterControl extends React.Component<CombinedProps> {
    render(): JSX.Element;
    private handleAddFilter;
    private getRemoveFilterCallback;
    private handleRemoveFilter;
    private getFilterLabel;
    private findFilterLabelByType;
}
declare const _default: (React.ComponentClass<Props, React.ComponentState> & typeof FilterControl) | (React.StatelessComponent<Props> & typeof FilterControl);
export default _default;
