import * as React from 'react';
import { Months, Year } from '../../../../../DatePicker';
import { WithAppProviderProps } from '../../../../../AppProvider';
declare type DateOptionType = 'past' | 'future' | 'full';
export interface Props {
    dateOptionType?: DateOptionType;
    filterValue?: string;
    filterKey?: string;
    filterMinKey: string;
    filterMaxKey: string;
    onFilterValueChange(filterValue?: string): void;
    onFilterKeyChange(filterKey?: string): void;
}
interface State {
    selectedDate?: Date;
    userInputDate?: string;
    userInputDateError?: string;
    datePickerMonth: Months;
    datePickerYear: Year;
    initialConsumerFilterKey?: string;
}
export declare type CombinedProps = Props & WithAppProviderProps;
export declare enum DateFilterOption {
    PastWeek = "past_week",
    PastMonth = "past_month",
    PastQuarter = "past_quarter",
    PastYear = "past_year",
    ComingWeek = "coming_week",
    ComingMonth = "coming_month",
    ComingQuarter = "coming_quarter",
    ComingYear = "coming_year",
    OnOrBefore = "on_or_before",
    OnOrAfter = "on_or_after"
}
declare class DateSelector extends React.PureComponent<CombinedProps, State> {
    state: State;
    render(): JSX.Element;
    private readonly dateComparatorOptions;
    private readonly datePastOptions;
    private readonly dateFutureOptions;
    private readonly dateOptionTypes;
    private readonly now;
    private readonly dateTextFieldValue;
    private handleDateFilterOptionsChange;
    private handleDateFieldChange;
    private handleDateBlur;
    private handleDateChanged;
    private handleDatePickerChange;
    private handleDatePickerMonthChange;
}
declare const _default: React.ComponentClass<Props, React.ComponentState> & typeof DateSelector;
export default _default;
