import * as React from 'react';
import { WithAppProviderProps } from '../../../../../AppProvider';
import { AppliedFilter, Filter } from '../../types';
export interface Props {
    filters: Filter[];
    resourceName: {
        singular: string;
        plural: string;
    };
    disabled: boolean;
    onAddFilter?(newFilter: AppliedFilter): void;
}
export declare type CombinedProps = Props & WithAppProviderProps;
export interface State {
    popoverActive: boolean;
    selectedFilter?: Filter;
    selectedFilterKey?: AppliedFilter['key'];
    selectedFilterValue?: AppliedFilter['value'];
}
export declare class FilterCreator extends React.PureComponent<CombinedProps, State> {
    state: State;
    private node;
    private readonly canAddFilter;
    render(): JSX.Element;
    private handleButtonFocus;
    private togglePopover;
    private handleFilterKeyChange;
    private handleFilterValueChange;
    private handleAddFilter;
}
declare const _default: React.ComponentClass<Props, React.ComponentState> & typeof FilterCreator;
export default _default;
