import * as React from 'react';
import { DisableableAction, WithContextTypes } from '../../../../types';
import { Props as AvatarProps } from '../../../Avatar';
import { Props as ThumbnailProps } from '../../../Thumbnail';
import { WithAppProviderProps } from '../../../AppProvider';
import { ResourceListContext } from '../../types';
export declare type ExceptionStatus = 'neutral' | 'warning' | 'critical';
export declare type MediaSize = 'small' | 'medium' | 'large';
export declare type MediaType = 'avatar' | 'thumbnail';
export interface BaseProps {
    /** Visually hidden text for screen readers */
    accessibilityLabel?: string;
    /** Id of the element the item onClick controls */
    ariaControls?: string;
    /** Tells screen reader the controlled element is expanded */
    ariaExpanded?: boolean;
    /** Unique identifier for the item */
    id: string;
    media?: React.ReactElement<AvatarProps | ThumbnailProps>;
    persistActions?: boolean;
    shortcutActions?: DisableableAction[];
    children?: React.ReactNode;
}
export interface PropsWithUrl extends BaseProps {
    url: string;
    onClick?(id?: string): void;
}
export interface PropsWithClick extends BaseProps {
    url?: string;
    onClick(id?: string): void;
}
export declare type Props = PropsWithUrl | PropsWithClick;
export interface State {
    actionsMenuVisible: boolean;
    focused: boolean;
    focusedInner: boolean;
}
export declare type CombinedProps = (PropsWithUrl & WithAppProviderProps & WithContextTypes<ResourceListContext>) | (PropsWithClick & WithAppProviderProps & WithContextTypes<ResourceListContext>);
export declare class Item extends React.PureComponent<CombinedProps, State> {
    state: State;
    private node;
    private checkboxId;
    render(): JSX.Element;
    private setNode;
    private handleAnchorFocus;
    private handleFocusedBlur;
    private handleFocus;
    private handleBlur;
    private handleMouseDown;
    private handleLargerSelectionArea;
    private handleSelection;
    private handleClick;
    private handleKeypress;
    private handleActionsClick;
    private handleCloseRequest;
    private isSelected;
    private compareEventNode;
}
declare const _default: (React.ComponentClass<Props, React.ComponentState> & typeof Item) | (React.StatelessComponent<Props> & typeof Item);
export default _default;
