import * as React from 'react';
import { ResourcePicker as AppBridgeResourcePicker } from '@shopify/app-bridge/actions';
import { WithAppProviderProps } from '../AppProvider';
export interface SelectPayload {
    /** The selected resources
     * @see {@link https://help.shopify.com/en/api/embedded-apps/app-bridge/actions/resourcepicker|resource picker documentation} for more information
     */
    selection: AppBridgeResourcePicker.ResourceSelection[];
}
export interface Props {
    /** Whether the picker is open or not */
    open: boolean;
    /** The type of resource you want to pick */
    resourceType: 'Product' | 'ProductVariant' | 'Collection';
    /** GraphQL initial search query for filtering resources available in the picker
     * @see {@link https://help.shopify.com/en/api/getting-started/search-syntax|search syntax} for more information
     */
    initialQuery?: string;
    /** Whether to show hidden products or not
     * @default true
     */
    showHidden?: boolean;
    /** Whether to allow selection of multiple items
     * @default true
     */
    allowMultiple?: boolean;
    /** Whether to show product variants or not. Only applies to the product resource type picker
     * @default true
     */
    showVariants?: boolean;
    /** Callback when a selection has been made */
    onSelection?(selectPayload: SelectPayload): void;
    /** Callback when the picker is closed without selection */
    onCancel?(): void;
}
export declare type CombinedProps = Props & WithAppProviderProps;
export declare class ResourcePicker extends React.PureComponent<CombinedProps, never> {
    private focusReturnPoint;
    private appBridgeResourcePicker;
    componentDidMount(): void;
    componentDidUpdate(prevProps: CombinedProps): void;
    componentWillUnmount(): void;
    render(): null;
}
declare const _default: React.ComponentClass<Props, React.ComponentState> & typeof ResourcePicker;
export default _default;
