import * as React from 'react';
import { WithAppProviderProps } from '../AppProvider';
export interface Props extends React.HTMLProps<HTMLDivElement> {
    /** Content to display in scrollable area */
    children?: React.ReactNode;
    /** Scroll content vertically */
    vertical?: boolean;
    /** Scroll content horizontally */
    horizontal?: boolean;
    /** Add a shadow when content is scrollable */
    shadow?: boolean;
    /** Slightly hints content upon mounting when scrollable */
    hint?: boolean;
    /** Called when scrolled to the bottom of the scroll area */
    onScrolledToBottom?(): void;
}
export interface State {
    topShadow: boolean;
    bottomShadow: boolean;
    scrollPosition: number;
}
export interface Context {
    scrollToPosition(scrollY: number): void;
}
export declare type CombinedProps = Props & WithAppProviderProps;
declare const _default: any;
export default _default;
