import * as React from 'react';
import { WithAppProviderProps } from '../AppProvider';
export interface Props {
    /** Page title, in large type */
    title?: string;
    /** Remove the normal max-width on the page */
    fullWidth?: boolean;
    /** Decreases the maximum layout width. Intended for single-column layouts */
    singleColumn?: boolean;
    /** Shows a skeleton over the primary action */
    primaryAction?: boolean;
    /** Number of secondary page-level actions to display */
    secondaryActions?: number;
    /** Shows a skeleton over the breadcrumb */
    breadcrumbs?: boolean;
    /** The child elements to render in the skeleton page. */
    children?: React.ReactNode;
}
export declare type CombinedProps = Props & WithAppProviderProps;
export declare class SkeletonPage extends React.PureComponent<CombinedProps, never> {
    render(): JSX.Element;
}
declare const _default: React.ComponentClass<Props, React.ComponentState> & typeof SkeletonPage;
export default _default;
