import * as React from 'react';
import { WithAppProviderProps } from '../AppProvider';
export declare type Color = 'white' | 'teal' | 'inkLightest';
export declare type Size = 'small' | 'large';
export interface Props {
    /**
     * Color of spinner
     * @default 'teal'
     */
    color?: Color;
    /**
     * Size of spinner
     * @default 'large'
     */
    size?: Size;
    /** Accessible label for the spinner */
    accessibilityLabel?: string;
}
export declare type CombinedProps = Props & WithAppProviderProps;
declare function Spinner({ size, color, accessibilityLabel, polaris: { intl }, }: CombinedProps): JSX.Element;
declare const _default: React.ComponentClass<Props, React.ComponentState> & typeof Spinner;
export default _default;
