import * as React from 'react';
export interface State {
    isSticky: boolean;
    style: Object;
}
export declare type Props = {
    /** Element outlining the fixed position boundaries */
    boundingElement?: HTMLElement | null;
    /** Offset vertical spacing from the top of the scrollable container */
    offset?: boolean;
    /** Should the element remain in a fixed position when the layout is stacked (smaller screens)  */
    disableWhenStacked?: boolean;
} & ({
    children: React.ReactNode;
} | {
    children(isSticky: boolean): React.ReactNode;
});
export default class Sticky extends React.Component<Props, State> {
    static contextTypes: React.ValidationMap<any>;
    state: State;
    private placeHolderNode;
    private stickyNode;
    componentDidMount(): void;
    componentWillUnmount(): void;
    render(): JSX.Element;
    private setPlaceHolderNode;
    private setStickyNode;
    private handlePositioning;
    private adjustPlaceHolderNode;
}
