import * as React from 'react';
import { TabDescriptor } from './types';
import { Panel } from './components';
export interface Props {
    /** Content to display in tabs */
    children?: React.ReactNode;
    /** Index of selected tab */
    selected: number;
    /** List of tabs */
    tabs: TabDescriptor[];
    /** Fit tabs to container */
    fitted?: boolean;
    /** Callback when tab is selected */
    onSelect?(selectedTabIndex: number): void;
}
export interface State {
    disclosureWidth: number;
    tabWidths: number[];
    visibleTabs: number[];
    hiddenTabs: number[];
    containerWidth: number;
    showDisclosure: boolean;
    tabToFocus: number;
}
export default class Tabs extends React.PureComponent<Props, State> {
    static Panel: typeof Panel;
    static getDerivedStateFromProps(nextProps: Props, prevState: State): {
        visibleTabs: number[];
        hiddenTabs: number[];
        selected: number;
    };
    state: State;
    render(): JSX.Element;
    private handleKeyPress;
    private renderTabMarkup;
    private handleFocus;
    private handleBlur;
    private handleDisclosureActivatorClick;
    private handleClose;
    private handleMeasurement;
    private handleTabClick;
}
