import * as React from 'react';
import { Action } from '../Labelled';
import { Error } from '../../types';
import { WithAppProviderProps } from '../AppProvider';
export declare type Type = 'text' | 'email' | 'number' | 'password' | 'search' | 'tel' | 'url' | 'date' | 'datetime-local' | 'month' | 'time' | 'week' | 'currency';
export interface State {
    height?: number | null;
    focus: boolean;
    id: string;
}
export interface BaseProps {
    /** Text to display before value */
    prefix?: React.ReactNode;
    /** Text to display after value */
    suffix?: React.ReactNode;
    /** Hint text to display */
    placeholder?: string;
    /** Initial value for the input */
    value?: string;
    /** Additional hint text to display */
    helpText?: React.ReactNode;
    /** Label for the input */
    label: string;
    /** Adds an action to the label */
    labelAction?: Action;
    /** Visually hide the label */
    labelHidden?: boolean;
    /** Disable the input */
    disabled?: boolean;
    /** Disable editing of the input */
    readOnly?: boolean;
    /** Automatically focus the input */
    autoFocus?: boolean;
    /** Force the focus state on the input */
    focused?: boolean;
    /** Allow for multiple lines of input */
    multiline?: boolean | number;
    /** Error to display beneath the label */
    error?: Error | boolean;
    /** An element connected to the right of the input */
    connectedRight?: React.ReactNode;
    /** An element connected to the left of the input */
    connectedLeft?: React.ReactNode;
    /** Determine type of input */
    type?: Type;
    /** Name of the input */
    name?: string;
    /** ID for the input */
    id?: string;
    /** Defines a specific role attribute for the input */
    role?: string;
    /** Limit increment value for numeric and date-time inputs */
    step?: number;
    /** Enable automatic completion by the browser */
    autoComplete?: boolean | string;
    /** Mimics the behavior of the native HTML attribute, limiting how high the spinner can increment the value */
    max?: number;
    /** Maximum character length for an input */
    maxLength?: number;
    /** Mimics the behavior of the native HTML attribute, limiting how low the spinner can decrement the value */
    min?: number;
    /** Minimum character length for an input */
    minLength?: number;
    /** A regular expression to check the value against */
    pattern?: string;
    /** Indicate whether value should have spelling checked */
    spellCheck?: boolean;
    /** Indicates the id of a component owned by the input */
    ariaOwns?: string;
    /** Indicates the id of a component controlled by the input */
    ariaControls?: string;
    /** Indicates the id of a related component’s visually focused element to the input */
    ariaActiveDescendant?: string;
    /** Indicates what kind of user input completion suggestions are provided */
    ariaAutocomplete?: string;
    /** Indicates whether or not the character count should be displayed */
    showCharacterCount?: boolean;
    /** Callback when value is changed */
    onChange?(value: string, id: string): void;
    /** Callback when input is focused */
    onFocus?(): void;
    /** Callback when focus is removed */
    onBlur?(): void;
}
export interface NonMutuallyExclusiveProps extends BaseProps {
}
export declare type Props = NonMutuallyExclusiveProps & ({
    readOnly: true;
} | {
    disabled: true;
} | {
    onChange(value: string, id: string): void;
});
export declare type CombinedProps = Props & WithAppProviderProps;
declare class TextField extends React.PureComponent<CombinedProps, State> {
    static getDerivedStateFromProps(nextProps: CombinedProps, prevState: State): {
        id: string;
    };
    private input;
    private buttonPressTimer;
    constructor(props: CombinedProps);
    componentDidMount(): void;
    componentDidUpdate({ focused: wasFocused }: CombinedProps): void;
    render(): JSX.Element;
    private setInput;
    private handleNumberChange;
    private handleExpandingResize;
    private handleKeyPress;
    private handleChange;
    private handleFocus;
    private handleBlur;
    private handleClick;
    private handleButtonPress;
    private handleButtonRelease;
}
declare const _default: React.ComponentClass<Props, React.ComponentState> & typeof TextField;
export default _default;
