import * as React from 'react';
import { Theme, ThemeProviderContext } from './types';
export interface Props {
    /** Custom logos and colors provided to select components */
    theme: Theme;
    /** The content to display */
    children?: React.ReactNode;
}
export default class ThemeProvider extends React.Component<Props> {
    static childContextTypes: {
        polarisTheme: any;
    };
    themeContext: ThemeProviderContext;
    private subscriptions;
    private colors;
    constructor(props: Props);
    componentWillReceiveProps({ theme }: Props): void;
    getChildContext(): ThemeProviderContext;
    render(): JSX.Element;
    subscribe: (callback: () => void) => void;
    unsubscribe: (callback: () => void) => void;
    createStyles(): {} | null;
}
