import * as React from 'react';
import { PreferredPosition } from '../PositionedOverlay';
export interface Props {
    /** The element that will activate to tooltip */
    children?: React.ReactNode;
    /** The content to display within the tooltip */
    content: string;
    /** Display tooltip with a light background */
    light?: boolean;
    /** Toggle whether the tooltip is visible */
    active?: boolean;
    /**
     * The direction the tooltip tries to display
     * @default 'below'
     */
    preferredPosition?: PreferredPosition;
    /**
     * The element type to wrap the activator in
     * @default 'span'
     */
    activatorWrapper?: string;
}
export interface State {
    active: boolean;
    activatorNode: HTMLElement | null;
}
export default class Tooltip extends React.PureComponent<Props, State> {
    state: State;
    private id;
    private activatorContainer;
    componentDidMount(): void;
    componentDidUpdate(): void;
    render(): JSX.Element;
    private setActivator;
    private handleFocus;
    private handleBlur;
    private handleMouseEnter;
    private handleMouseLeave;
    private setAccessibilityAttributes;
}
