import * as React from 'react';
import { WithAppProviderProps } from '../AppProvider';
import { SearchField, SearchProps, Menu } from './components';
export interface Props {
    /** Toggles whether or not a navigation component has been provided. Controls the presence of the mobile nav toggle button */
    showNavigationToggle?: boolean;
    /** Accepts a user component that is made available as a static member of the top bar component and renders as the primary menu */
    userMenu?: React.ReactNode;
    /** Accepts a menu component that is made available as a static member of the top bar component */
    secondaryMenu?: React.ReactNode;
    /** Accepts a component that is ideally used to help users switch between different contexts */
    contextControl?: React.ReactNode;
    /** Accepts a search field component that is made available as a `TextField` static member of the top bar component */
    searchField?: React.ReactNode;
    /** Accepts a search results component that is ideally composed of a card component containing a list of actionable search results */
    searchResults?: React.ReactNode;
    /** A boolean property indicating whether search results are currently visible. */
    searchResultsVisible?: boolean;
    /** A callback function that handles the dismissal of search results */
    onSearchResultsDismiss?: SearchProps['onDismiss'];
    /** A callback function that handles hiding and showing mobile navigation */
    onNavigationToggle?(): void;
}
export declare type ComposedProps = Props & WithAppProviderProps;
export interface State {
    focused: boolean;
}
export declare class TopBar extends React.PureComponent<ComposedProps, State> {
    static UserMenu: React.ComponentClass<import("./components/UserMenu/components/UserMenu/UserMenu").Props, React.ComponentState>;
    static SearchField: typeof SearchField;
    static Menu: typeof Menu;
    state: State;
    render(): JSX.Element;
    private handleFocus;
    private handleBlur;
}
declare const _default: React.ComponentClass<Props, React.ComponentState> & typeof TopBar;
export default _default;
