import * as React from 'react';
export interface Props {
    /** Initial value for the input */
    value: string;
    /** Hint text to display */
    placeholder?: string;
    /** Force the focus state on the input */
    focused?: boolean;
    /** Force a state where search is active but the text field component is not focused */
    active?: boolean;
    /** Callback when value is changed */
    onChange(value: string): void;
    /** Callback when input is focused */
    onFocus?(): void;
    /** Callback when focus is removed */
    onBlur?(): void;
    /** Callback when search field cancel button is clicked */
    onCancel?(): void;
}
export default class SearchField extends React.Component<Props, never> {
    private input;
    componentDidMount(): void;
    componentDidUpdate({ focused: wasFocused }: Props): void;
    render(): JSX.Element;
    private handleFocus;
    private handleBlur;
    private handleClear;
    private handleChange;
}
