import * as React from 'react';
import { ReactComponent } from '@shopify/react-utilities/types';
import { WithAppProviderProps } from '../AppProvider/utilities';
export interface Props extends React.HTMLProps<HTMLAnchorElement> {
    /** A destination to link to */
    url: string;
    /** Forces url to open in a new tab */
    external?: boolean;
    /** Tells the browser to download the url instead of opening it. Provides a hint for the downloaded filename if it is a string value. */
    download?: string | boolean;
    /**	Content to display inside the link */
    children?: React.ReactNode;
    [key: string]: any;
}
export declare type LinkLikeComponent = ReactComponent<Props> | undefined;
export declare type CombinedProps = Props & WithAppProviderProps;
export declare class UnstyledLink extends React.PureComponent<CombinedProps, never> {
    render(): JSX.Element;
}
declare const _default: (React.ComponentClass<Props, React.ComponentState> & typeof UnstyledLink) | (React.StatelessComponent<Props> & typeof UnstyledLink);
export default _default;
