import { ReactWrapper, CommonWrapper, ShallowWrapper, MountRendererProps, ShallowRendererProps } from 'enzyme';
import * as React from 'react';
import { PolarisContext } from '../components/types';
export declare type AnyWrapper = ReactWrapper<any, any> | CommonWrapper<any, any>;
export declare function findByTestID(root: ReactWrapper<any, any>, id: string): any;
export declare function matchByTestID(root: ReactWrapper<any, any>, regexp: RegExp): ReactWrapper<any, any, React.Component<{}, {}, any>>;
export declare function trigger(wrapper: AnyWrapper, keypath: string, ...args: any[]): any;
/**
 * This is needed for updating the enzyme wrapper and react instance when we deeply change the context.
 * root.update() should work, but it doesn’t currently (see https://github.com/airbnb/enzyme/issues/1329).
 */
export declare function forceUpdate(root: AnyWrapper): void;
export declare function layeredContent(root: ReactWrapper<any, any>): any;
export interface ReactWrapperPredicate {
    (wrapper: ReactWrapper<any, any>): boolean;
}
export declare function findWhereInLayeredContent(root: ReactWrapper<any, any>, predicate: ReactWrapperPredicate): any;
export declare function mountWithAppProvider<P>(node: React.ReactElement<P>, options?: MountRendererProps): ReactWrapper<P, any>;
export declare function shallowWithAppProvider<P>(node: React.ReactElement<P>, options?: ShallowRendererProps): ShallowWrapper<P, any>;
export declare function createPolarisProps(): PolarisContext;
